﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.Security.AntiXss;
using System.Web.UI;
using System.IO;
using System.Globalization;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.CRS.BO;
using VIRP.CRS.BLL;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class QuestionnaireSummary : EfrBasePage
    {
        const string NotRecorded = "Not Recorded";
        string userId = "";
        int registryId = 0;
        int surveyId = 0;
        int bioWkfCaseTypeId = 0;
        int fragWkfCaseTypeId = 0;

        VIRP.CRS.BO.WKF_CASE_ACTIVITY wca = new VIRP.CRS.BO.WKF_CASE_ACTIVITY();
        VIRP.CRS.BO.WKF_CASE wc = new VIRP.CRS.BO.WKF_CASE();

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/Questionnaires/Surveys.aspx",
        };

        public QuestionnaireSummary()
        {
            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                SetReferringPage();

                userId = HttpContext.Current.User.Identity.Name;
                registryId = UserSession.CurrentRegistryId;
                
                if (int.TryParse(Request.QueryString["activityId"], out surveyId))
                {
                    wca = WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);
                    wc = VIRP.CRS.BLL.WKF_CASEManager.GetItem(userId, registryId, wca.WKF_CASE_ID);

                    SetStdWkfCaseTypeIds();

                    using (StringWriter sw = new StringWriter())
                    {
                        if (wc.STD_WKFCASETYPE_ID == bioWkfCaseTypeId)
                        {
                            SetupBioQuestionnaireReport(sw);
                        }
                        else if (wc.STD_WKFCASETYPE_ID == fragWkfCaseTypeId)
                        {
                            SetupFragQuestionnaireReport(sw);
                        }
                    }
                }
            }
        }

        private string ConvertIndicator(char? indicator)
        {
            if (indicator.HasValue)
            {
                string data = indicator.Value.ToString();
                return data.Replace("Y", "Yes").Replace("N", "No").Replace("U", "Unknown").Replace("R", "Not Recorded");
            }
            else
            {
                return String.Empty;
            }
        }

        private string ConvertFlags(bool? flag)
        {
            if (flag.HasValue)
            {
                return flag.Value ? "Yes" : "No";
            }
            else
            {
                return String.Empty;
            }
        }

        private string GetInjuredBodyParts(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit)
        {
            List<string> parts = new List<string>();

            if (bioKit.Injury_Back_Head.GetValueOrDefault())
                parts.Add("Back Head");

            if (bioKit.Injury_Back_Neck.GetValueOrDefault())
                parts.Add("Back Neck");

            if (bioKit.Injury_Upper_Back.GetValueOrDefault())
                parts.Add("Upper Back");

            if (bioKit.Injury_Lower_Back.GetValueOrDefault())
                parts.Add("Lower Back");

            if (bioKit.Injury_Buttocks.GetValueOrDefault())
                parts.Add("Buttocks");

            if (bioKit.Injury_Front_Head.GetValueOrDefault())
                parts.Add("Front Head");

            if (bioKit.Injury_Front_Neck.GetValueOrDefault())
                parts.Add("Front Neck");

            if (bioKit.Injury_Chest.GetValueOrDefault())
                parts.Add("Chest");

            if (bioKit.Injury_Abdomen.GetValueOrDefault())
                parts.Add("Abdomen");

            if (bioKit.Injury_Groin_Pelvis.GetValueOrDefault())
                parts.Add("Groin/Pelvis");

            if (bioKit.Injury_Left_Shoulder.GetValueOrDefault())
                parts.Add("Left Shoulder");

            if (bioKit.Injury_Left_Upper_Arm.GetValueOrDefault())
                parts.Add("Left Upper Arm");

            if (bioKit.Injury_Left_Lower_Arm.GetValueOrDefault())
                parts.Add("Left Lower Arm");

            if (bioKit.Injury_Left_Hand_Wrist_Fingers.GetValueOrDefault())
                parts.Add("Left Hand, Wrist, Fingers");

            if (bioKit.Injury_Left_Upper_Leg_Thigh.GetValueOrDefault())
                parts.Add("Left Upper Leg and Thigh");

            if (bioKit.Injury_Left_Knee.GetValueOrDefault())
                parts.Add("Left Knee");

            if (bioKit.Injury_Left_Lower_Leg.GetValueOrDefault())
                parts.Add("Left Lower Leg");

            if (bioKit.Injury_Left_Ankle.GetValueOrDefault())
                parts.Add("Left Ankle");

            if (bioKit.Injury_Left_Foot_Toes.GetValueOrDefault())
                parts.Add("Left Foot and Toes");

            if (bioKit.Injury_Right_Shoulder.GetValueOrDefault())
                parts.Add("Right Shoulder");

            if (bioKit.Injury_Right_Upper_Arm.GetValueOrDefault())
                parts.Add("Right Upper Arm");

            if (bioKit.Injury_Right_Lower_Arm.GetValueOrDefault())
                parts.Add("Right Lower Arm");

            if (bioKit.Injury_Right_Hand_Wrist_Fingers.GetValueOrDefault())
                parts.Add("Right Hand, Wrist, Fingers");

            if (bioKit.Injury_Right_Upper_Leg_Thigh.GetValueOrDefault())
                parts.Add("Right Upper Leg and Thigh");

            if (bioKit.Injury_Right_Knee.GetValueOrDefault())
                parts.Add("Right Knee");

            if (bioKit.Injury_Right_Lower_Leg.GetValueOrDefault())
                parts.Add("Right Lower Leg");

            if (bioKit.Injury_Right_Ankle.GetValueOrDefault())
                parts.Add("Right Ankle");

            if (bioKit.Injury_Right_Foot_Toes.GetValueOrDefault())
                parts.Add("Right Foot and Toes");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetTreatmentOptions(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit)
        {
            List<string> options = new List<string>();

            if (bioKit.TREATLOCAT_FIELD)
            {
                string fieldLocation = !String.IsNullOrEmpty(bioKit.TREATLOCAT_FIELD_Where) ? " (" + bioKit.TREATLOCAT_FIELD_Where + ")" : String.Empty;
                options.Add("In The Field" + fieldLocation);
            }

            if (bioKit.TREATLOCAT_SUPPORTHOSP)
            {
                string fieldLocation = !String.IsNullOrEmpty(bioKit.TREATLOCAT_SUPPORTHOSP_Where) ? " (" + bioKit.TREATLOCAT_SUPPORTHOSP_Where + ")" : String.Empty;
                options.Add("At a Combat Support Hospital" + fieldLocation);
            }

            if (bioKit.TREATLOCAT_GERMANY)
            {
                options.Add("At Landstuhl, Germany");
            }

            if (bioKit.TREATLOCAT_FACILITY)
            {
                string fieldLocation = !String.IsNullOrEmpty(bioKit.TREATLOCAT_FACILITY_Where) ? " (" + bioKit.TREATLOCAT_FACILITY_Where + ")" : String.Empty;
                options.Add("At a U.S. based Medical Treatment Facility" + fieldLocation);
            }

            if (bioKit.TREATLOCAT_MEDCENTER)
            {
                string fieldLocation = !String.IsNullOrEmpty(bioKit.TREATLOCAT_MEDCENTER_Where) ? " (" + bioKit.TREATLOCAT_MEDCENTER_Where + ")" : String.Empty;
                options.Add("At a VA Medical Center" + fieldLocation);
            }

            return String.Join("; ", options.ToArray());
        }
        private string GetFragsBodyParts(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT bioKit)
        {
            List<string> parts = new List<string>();

            if (bioKit.Remain_in_Back_Head.GetValueOrDefault())
                parts.Add("Back Head");

            if (bioKit.Remain_in_Back_Neck.GetValueOrDefault())
                parts.Add("Back Neck");

            if (bioKit.Remain_in_Upper_Back.GetValueOrDefault())
                parts.Add("Upper Back");

            if (bioKit.Remain_in_Lower_Back.GetValueOrDefault())
                parts.Add("Lower Back");

            if (bioKit.Remain_in_Buttocks.GetValueOrDefault())
                parts.Add("Buttocks");

            if (bioKit.Remain_in_Front_Head.GetValueOrDefault())
                parts.Add("Front Head");

            if (bioKit.Remain_in_Front_Neck.GetValueOrDefault())
                parts.Add("Front Neck");

            if (bioKit.Remain_in_Chest.GetValueOrDefault())
                parts.Add("Chest");

            if (bioKit.Remain_in_Abdomen.GetValueOrDefault())
                parts.Add("Abdomen");

            if (bioKit.Remain_in_Groin_Pelvis.GetValueOrDefault())
                parts.Add("Groin/Pelvis");

            if (bioKit.Remain_in_Left_Shoulder.GetValueOrDefault())
                parts.Add("Left Shoulder");

            if (bioKit.Remain_in_Left_Upper_Arm.GetValueOrDefault())
                parts.Add("Left Upper Arm");

            if (bioKit.Remain_in_Left_Lower_Arm.GetValueOrDefault())
                parts.Add("Left Lower Arm");

            if (bioKit.Remain_in_Left_Hand_Wrist_Fingers.GetValueOrDefault())
                parts.Add("Left Hand, Wrist, Fingers");

            if (bioKit.Remain_in_Left_Upper_Leg_Thigh.GetValueOrDefault())
                parts.Add("Left Upper Leg and Thigh");

            if (bioKit.Remain_in_Left_Knee.GetValueOrDefault())
                parts.Add("Left Knee");

            if (bioKit.Remain_in_Left_Lower_Leg.GetValueOrDefault())
                parts.Add("Left Lower Leg");

            if (bioKit.Remain_in_Left_Ankle.GetValueOrDefault())
                parts.Add("Left Ankle");

            if (bioKit.Remain_in_Left_Foot_Toes.GetValueOrDefault())
                parts.Add("Left Foot and Toes");

            if (bioKit.Remain_in_Right_Shoulder.GetValueOrDefault())
                parts.Add("Right Shoulder");

            if (bioKit.Remain_in_Right_Upper_Arm.GetValueOrDefault())
                parts.Add("Right Upper Arm");

            if (bioKit.Remain_in_Right_Lower_Arm.GetValueOrDefault())
                parts.Add("Right Lower Arm");

            if (bioKit.Remain_in_Right_Hand_Wrist_Fingers.GetValueOrDefault())
                parts.Add("Right Hand, Wrist, Fingers");

            if (bioKit.Remain_in_Right_Upper_Leg_Thigh.GetValueOrDefault())
                parts.Add("Right Upper Leg and Thigh");

            if (bioKit.Remain_in_Right_Knee.GetValueOrDefault())
                parts.Add("Right Knee");

            if (bioKit.Remain_in_Right_Lower_Leg.GetValueOrDefault())
                parts.Add("Right Lower Leg");

            if (bioKit.Remain_in_Right_Ankle.GetValueOrDefault())
                parts.Add("Right Ankle");

            if (bioKit.Remain_in_Right_Foot_Toes.GetValueOrDefault())
                parts.Add("Right Foot and Toes");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetOccupationHobbyFactors(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            if (kit.PAST_YEAR_WELDING_FLAG.GetValueOrDefault())
                parts.Add("Welding");
            if (kit.PAST_YEAR_SOLDERING_FLAG.GetValueOrDefault())
                parts.Add("Soldering");
            if (kit.PAST_YEAR_SMELTING_FLAG.GetValueOrDefault())
                parts.Add("Smelting");
            if (kit.PAST_YEAR_MINING_FLAG.GetValueOrDefault())
                parts.Add("Mining");
            if (kit.PAST_YEAR_DEMOLITION_FLAG.GetValueOrDefault())
                parts.Add("Demolition");
            if (kit.PAST_YEAR_SAND_BLASTING_FLAG.GetValueOrDefault())
                parts.Add("Sand Blasting");
            if (kit.PAST_YEAR_MACHINING_FLAG.GetValueOrDefault())
                parts.Add("Machining, grinding of metals");
            if (kit.PAST_YEAR_OTHER_MANUFACTURING_FLAG.GetValueOrDefault())
                parts.Add("Other manufacturing that involves working with metals");
            if (kit.PAST_YEAR_FIRING_RANGE_USE_FLAG.GetValueOrDefault())
                parts.Add("Firing range use or maintenance");
            if (kit.PAST_YEAR_MAKING_BULLETS_FLAG.GetValueOrDefault())
                parts.Add("Making bullets or shot");
            if (kit.PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY_FLAG.GetValueOrDefault())
                parts.Add("None");
            if (kit.PAST_YEAR_LEAD_PAINT_FLAG.GetValueOrDefault())
                parts.Add("Lead paint");
            if (kit.PAST_YEAR_ANTI_FOULANT_FLAG.GetValueOrDefault())
                parts.Add("Anti-foulant(marine) paint");
            if (kit.PAST_YEAR_WOOD_PRESERVATIVES_FLAG.GetValueOrDefault())
                parts.Add("Wood preservatives");
            if (kit.PAST_YEAR_FISHING_WEIGHTS_FLAG.GetValueOrDefault())
                parts.Add("Fishing weights");
            if (kit.PAST_YEAR_STAINED_GLASS_FLAG.GetValueOrDefault())
                parts.Add("Stained glass");
            if (kit.PAST_YEAR_JEWELRY_OR_ART_METALS_FLAG.GetValueOrDefault())
                parts.Add("Jewelry or art");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetCurrentImplants(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            string sOther = "";

            if (kit.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG.GetValueOrDefault())
                parts.Add("Pacemaker/Defibrillator");
            if (kit.DEVICE_IMPLANTED_STENTS_FLAG.GetValueOrDefault())
                parts.Add("Stents");
            if (kit.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG.GetValueOrDefault())
                parts.Add("Surgical clips/wires");
            if (kit.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG.GetValueOrDefault())
                parts.Add("Metal plates/screws/rods");
            if (kit.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG.GetValueOrDefault())
                parts.Add("Dental implants");
            if (kit.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG.GetValueOrDefault())
                parts.Add("Hip/knee/Shoulder replacements");

            if (kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG.GetValueOrDefault())
            {
                sOther = "Other";

                if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC))
                    sOther += "&nbsp;(" + kit.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC + ")";

                parts.Add(sOther);
            }

            if (kit.DEVICE_IMPLANTED_NONE_FLAG.GetValueOrDefault())
                parts.Add("None");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetCurrentImplantLocations(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_LOCATION1))
                parts.Add(kit.DEVICE_IMPLANTED_LOCATION1);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_LOCATION2))
                parts.Add(kit.DEVICE_IMPLANTED_LOCATION2);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_LOCATION3))
                parts.Add(kit.DEVICE_IMPLANTED_LOCATION3);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_LOCATION4))
                parts.Add(kit.DEVICE_IMPLANTED_LOCATION4);

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetCurrentImplantYears(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_YEAR1))
                parts.Add(kit.DEVICE_IMPLANTED_YEAR1);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_YEAR2))
                parts.Add(kit.DEVICE_IMPLANTED_YEAR2);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_YEAR3))
                parts.Add(kit.DEVICE_IMPLANTED_YEAR3);
            if (!String.IsNullOrEmpty(kit.DEVICE_IMPLANTED_YEAR4))
                parts.Add(kit.DEVICE_IMPLANTED_YEAR4);

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetOtherFactors1(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            if (kit.HAVE_METAL_TEETH_BRACES_FLAG == true)
                parts.Add("Metal braces on teeth");
            if (kit.HAVE_PIERCINGS_FLAG == true)
                parts.Add("Piercings");
            if (kit.HAVE_TATOOS_FLAG == true)
                parts.Add("Tatoos");
            if (kit.HAVE_NONE_ABOVE_FLAG == true)
                parts.Add("None");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private string GetOtherFactors2(QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit)
        {
            List<string> parts = new List<string>();

            if (kit.ROUTINELY_USE_ZINC_SUNBLOCK_FLAG == true)
                parts.Add("Zinc sunblock");
            if (kit.ROUTINELY_USE_DIETARY_SUPPLEMENTS_FLAG == true)
                parts.Add("Nutritional or dietary supplements");
            if (kit.ROUTINELY_USE_VITAMINS_FLAG == true)
                parts.Add("Vitamins");
            if (kit.ROUTINELY_USE_AYURVEDIC_MEDS_FLAG == true)
                parts.Add("Ayurvedic medicines");
            if (kit.ROUTINELY_USE_DENTURE_CREAM_FLAG == true)
                parts.Add("Denture cream");
            if (kit.ROUTINELY_USE_NONE_ABOVE_FLAG == true)
                parts.Add("None");

            string results = String.Join("; ", parts.ToArray());

            return results;
        }

        private void SetupBioQuestionnaireReport(StringWriter writer)
        {
            QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT kit = QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);
            VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItemComplete(userId, registryId, wc.PATIENT_ID);

            if (p != null)
            {
                string formVersion = "";

                HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "colgroup");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "22pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Biomonitoring Questionnaire/Form <br/> for&nbsp;" + AntiXssEncoder.HtmlEncode(p.LAST_NAME, false) + ",&nbsp;" + AntiXssEncoder.HtmlEncode(p.FIRST_NAME, false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(p.MIDDLE_NAME, false));
                htmlWriter.WriteBreak();

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "colgroup");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Entered/Updated by&nbsp;" + kit.UPDATEDBY + "&nbsp;on&nbsp;" + kit.UPDATED.ToShortDateString());
                htmlWriter.WriteBreak();

                if (kit.FORM_2009_FLAG == true)
                    formVersion = "Mar. 2009";
                if (kit.FORM_2012_FLAG == true)
                {
                    if (formVersion.Length > 0)
                        formVersion += " and Aug. 2012";
                    else
                        formVersion = "Aug. 2012";
                }

                htmlWriter.Write("Data input with online form version(s)&nbsp;" + formVersion);

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "col");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Question");
                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "col");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Answer");
                htmlWriter.RenderEndTag();

                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Name of Veterans Administration Medical Center (VAMC) Where Patient is Being Seen:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(kit.VAMC_Name);
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Location of VAMC Where Patient is Being Seen:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(kit.VAMC_Street_Address1);
                htmlWriter.WriteBreak();
                htmlWriter.Write(kit.VAMC_Street_Address2);
                htmlWriter.WriteBreak();
                htmlWriter.Write(kit.VAMC_Street_Address3);
                htmlWriter.WriteBreak();
                htmlWriter.Write(kit.VAMC_City);
                htmlWriter.Write("&nbsp;");
                htmlWriter.Write(kit.VAMC_State);
                htmlWriter.Write("&nbsp;");

                htmlWriter.Write(kit.VAMC_PostalCiode);

                if (!String.IsNullOrEmpty(kit.VAMC_ZipPlus4))
                {
                    htmlWriter.Write("-");
                    htmlWriter.Write(kit.VAMC_ZipPlus4);
                }
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Form Completion Date:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                if (kit.Form_Complete_Date.HasValue)

                    htmlWriter.Write(kit.Form_Complete_Date.Value.ToShortDateString());
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Branch of Service:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                bool first = true;

                if (kit.BRANCH_OF_SERVICE_ARMY == true)
                {
                    htmlWriter.Write("Army");
                    first = false;
                }
                if (kit.BRANCH_OF_SERVICE_NAVY == true)
                {
                    if (!first)
                        htmlWriter.WriteBreak();
                    else
                        first = false;

                    htmlWriter.Write("Navy");
                }
                if (kit.BRANCH_OF_SERVICE_MARINES == true)
                {
                    if (!first)
                        htmlWriter.WriteBreak();
                    else
                        first = false;

                    htmlWriter.Write("Marine Corps");
                }
                if (kit.BRANCH_OF_SERVICE_AIRFORCE == true)
                {
                    if (!first)
                        htmlWriter.WriteBreak();
                    else
                        first = false;

                    htmlWriter.Write("Air Force");
                }
                if (kit.BRANCH_OF_SERVICE_NATIONALGUARD == true)
                {
                    if (!first)
                        htmlWriter.WriteBreak();
                    else
                        first = false;

                    htmlWriter.Write("National Guard");
                }
                if (kit.BRANCH_OF_SERVICE_RESERVE == true)
                {
                    if (!first)
                        htmlWriter.WriteBreak();
                    else
                        first = false;

                    htmlWriter.Write("Reserve");
                }

                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN == true ||
                    kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ == true ||
                    kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Geographic location when you received the injury that resulted in shrapnel or fragments being removed from or remaining in your body:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN == true)
                    {
                        htmlWriter.Write("Afghanistan");
                        htmlWriter.WriteBreak();
                    }

                    if (kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ == true)
                    {
                        htmlWriter.Write("Iraq");
                        htmlWriter.WriteBreak();
                    }

                    if (kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION == true)
                    {
                        htmlWriter.Write("Other");
                        htmlWriter.WriteBreak();
                    }

                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    if (kit.INJURY_GEOGRAPHICAL_LOCATION_IRAQ == true && !String.IsNullOrEmpty(kit.Injury_City))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Near What City or Region in Iraq:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(kit.Injury_City);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }

                    if (kit.INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION == true && !String.IsNullOrEmpty(kit.Injury_Geographical_Location_other))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Other Geographic Location Description:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(kit.Injury_Geographical_Location_other);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Date of Injury:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                if (kit.Injury_Month.HasValue)
                {
                    DateTimeFormatInfo mfi = new DateTimeFormatInfo();
                    if (kit.Injury_Month.Value > 0)
                        htmlWriter.Write("Month: " + mfi.GetMonthName(kit.Injury_Month.Value));
                    else
                        htmlWriter.Write("Month: unknown");
                }
                else
                    htmlWriter.Write("Month: unknown");

                htmlWriter.WriteBreak();

                if (kit.Injury_Day.HasValue)
                {
                    if (kit.Injury_Day.Value > 0)
                        htmlWriter.Write("Day: " + kit.Injury_Day.Value);
                    else
                        htmlWriter.Write("Day: unknown");
                }
                else
                    htmlWriter.Write("Day: unknown");

                htmlWriter.WriteBreak();

                if (kit.Injury_Year.HasValue)
                {
                    htmlWriter.Write("Year: " + kit.Injury_Year.Value);
                }
                else
                {
                    htmlWriter.Write("Year: unknown");
                }

                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.FORM_2009_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Who Referred You to the VA Medical Center for the Evaluation of Embedded Fragments:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (!String.IsNullOrEmpty(kit.Who_Referred_You))
                    {
                        htmlWriter.Write(kit.Who_Referred_You);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        if (kit.Who_Referred_You.Equals("Other"))
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                            htmlWriter.Write("Specify:");

                            htmlWriter.RenderEndTag();

                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(kit.Who_Referred_You_Other);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                        }
                    }
                    else
                    {
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Indication Patient was Injured by a Bullet:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(ConvertIndicator(kit.Bullet_Injury_Ind));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Indication Patient was Injured in a Blast or Explosion:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(ConvertIndicator(kit.Blast_Explosion_Ind));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.Blast_Explosion_Ind.HasValue)
                {
                    if (kit.Blast_Explosion_Ind.Value.Equals('Y'))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("How many meters from explosion:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(kit.Distance_from_Explosion_Meter);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in or on a Vehicle:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertIndicator(kit.Injured_on_Vehicle_Ind));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Improvised Explosive Device (IED):");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_IED_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Rocket Propelled Grenade (RPG):");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_RPG_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Land Mine:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_LandMine_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Grenade:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_Grenade_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Enemy Fire:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_EnemyFire_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Friendly Fire:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_FriendlyFire_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Unknown Source:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_UnknownSource_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Indication Patient was Injured in a Blast by Other Source:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertFlags(kit.Injured_by_OtherSource_FLAG));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();

                        if (kit.Injured_by_OtherSource_FLAG.HasValue)
                        {
                            if (kit.Injured_by_OtherSource_FLAG.Value)
                            {
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                                htmlWriter.Write("Identification of the Source of a Blast for Other Source:");

                                htmlWriter.RenderEndTag();

                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                                htmlWriter.Write(kit.Injured_by_OtherSource_Desc);
                                htmlWriter.Write("&nbsp;");
                                htmlWriter.RenderEndTag();
                                htmlWriter.RenderEndTag();
                            }
                        }
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Body Part(s) Where Injured:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(GetInjuredBodyParts(kit));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Indication if the Patient had Shrapnel, Fragments or Bullets Removed During Surgery:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(ConvertIndicator(kit.Shrapnel_Frag_Bullet_Surgery_Ind));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.Shrapnel_Frag_Bullet_Surgery_Ind.HasValue)
                {
                    if (kit.Shrapnel_Frag_Bullet_Surgery_Ind.Value.Equals('Y'))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Indication Fragment was Sent to the Lab for Analysis:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(ConvertIndicator(kit.Send_to_Lab_Analysis_Ind));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Indication Fragment Remains Embedded in Patient:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(ConvertIndicator(kit.Fragment_Remains_inPatient_Ind));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.Fragment_Remains_inPatient_Ind.HasValue)
                {
                    if (kit.Fragment_Remains_inPatient_Ind.Value.Equals('Y'))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Body Part(s) Where Fragments Remain:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(GetFragsBodyParts(kit));
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Identification of Where Were you Treated for this Injury:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(GetTreatmentOptions(kit));
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (kit.FORM_2012_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Past Year Occupation or Hobby that involved:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(GetOccupationHobbyFactors(kit));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Exposed to Metal Dust or Fumes for Occupation in the Past Year:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG.HasValue)
                        htmlWriter.Write(ConvertFlags(kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG));
                    else
                        htmlWriter.Write(NotRecorded);

                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    if (kit.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG == true)
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Description of Occupation:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(kit.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Exposed to Metal Dust or Fumes for Hobby in the Past Year::");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG.HasValue)
                        htmlWriter.Write(ConvertFlags(kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG));
                    else
                        htmlWriter.Write(NotRecorded);

                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    if (kit.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG == true)
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                        htmlWriter.Write("Description of Hobby:");

                        htmlWriter.RenderEndTag();

                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write(kit.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }
                }

                // 2012 Implants fields, but this contains 2009 field as well so always show.

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Current Metal Implants in Body:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                if (kit.DEVICE_IMPLANTED_NONE_FLAG == true)
                {
                    htmlWriter.Write("None");
                }
                else
                {
                    htmlWriter.Write(GetCurrentImplants(kit));
                }
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (!kit.DEVICE_IMPLANTED_NONE_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                    htmlWriter.Write("Location of Metal Implants:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(GetCurrentImplantLocations(kit));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                }

                if (kit.FORM_2012_FLAG == true && !kit.DEVICE_IMPLANTED_NONE_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                    htmlWriter.Write("Year of Metal Implants:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(GetCurrentImplantYears(kit));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                }

                if (kit.FORM_2012_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Currently have (braces, piercings, tattoos): ");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(GetOtherFactors1(kit));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    // 2012 'other factor' question (14)
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Routinely use/take (sunblock, supplements, etc):");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(GetOtherFactors2(kit));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                }

                if (kit.FORM_2009_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Do You Have Shrapnel or Fragments in Your Body That are Not Related to the Injury Above:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(ConvertIndicator(kit.Shrapnel_In_Body_Ind));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    if (kit.Shrapnel_In_Body_Ind.HasValue)
                    {
                        if (kit.Shrapnel_In_Body_Ind.Value.Equals('Y'))
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                            htmlWriter.Write("Description:");

                            htmlWriter.RenderEndTag();

                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(kit.Shrapnel_In_Body_Desc);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();

                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                            htmlWriter.Write("Location:");

                            htmlWriter.RenderEndTag();

                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write(kit.Shrapnel_In_Body_DescLoca);
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                        }
                    }

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Has a 24 Hour Urine Collection for Monitoring for Exposure to Contents of the Shrapnel or Fragments Been Performed:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write(ConvertIndicator(kit.Urine_Collection_Ind));
                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    if (kit.Urine_Collection_Ind.HasValue)
                    {
                        if (kit.Urine_Collection_Ind.Value.Equals('Y'))
                        {
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            htmlWriter.Write("&nbsp;&nbsp;&nbsp;&nbsp;");
                            htmlWriter.Write("Date Collected:");

                            htmlWriter.RenderEndTag();

                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                            htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                            htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                            if (kit.Date_Urine_Collected.HasValue)
                            {
                                htmlWriter.Write(DateTime.Parse(kit.Date_Urine_Collected.ToString()).ToShortDateString());
                            }
                            htmlWriter.Write("&nbsp;");
                            htmlWriter.RenderEndTag();
                            htmlWriter.RenderEndTag();
                        }
                    }
                }

                if (kit.FORM_2012_FLAG == true)
                {
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Primary Water Source:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG == true)
                        htmlWriter.Write("Community water source");
                    else if (kit.PRIMARY_WATER_PRIVATE_WELL_FLAG == true)
                        htmlWriter.Write("Private well");
                    else
                        htmlWriter.Write(NotRecorded);

                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Currently Smoke:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG.HasValue)
                    {
                        if (kit.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG == true)
                            htmlWriter.Write("Yes");
                        else
                            htmlWriter.Write("No");
                    }
                    else
                    {
                        htmlWriter.Write(NotRecorded);
                    }

                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();

                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    htmlWriter.Write("Currently Chew Tobacco:");

                    htmlWriter.RenderEndTag();

                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                    htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                    htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                    if (kit.CURRENTLY_CHEW_TOBACCO_FLAG.HasValue)
                    {
                        if (kit.CURRENTLY_CHEW_TOBACCO_FLAG == true)
                            htmlWriter.Write("Yes");
                        else
                            htmlWriter.Write("No");
                    }
                    else
                    {
                        htmlWriter.Write(NotRecorded);
                    }

                    htmlWriter.Write("&nbsp;");
                    htmlWriter.RenderEndTag();
                    htmlWriter.RenderEndTag();
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "3");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "center");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.WriteBreak();

                htmlWriter.Write("<b>VA Sensitive</b>");

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                //table
                htmlWriter.RenderEndTag();
                //center
                htmlWriter.RenderEndTag();
                //body
                htmlWriter.RenderEndTag();
                //html
                htmlWriter.RenderEndTag();

                ReportHTML.Text = writer.ToString();
            }
            else
            {
                ReportHTML.Text = "There was an error retrieving this Questionnaire";
            }
        }
        private void SetupFragQuestionnaireReport(StringWriter writer)
        {
            QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORM fragKit = QUES_FRAGMENT_SPECIMEN_COLLECTION_KIT_FORMManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);
            VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItemComplete(userId, registryId, wc.PATIENT_ID);

            if (p != null)
            {
                HtmlTextWriter htmlWriter = new HtmlTextWriter(writer);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Html);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Body);
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Center);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Border, "1");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderStyle, "solid");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BorderColor, "black");

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "3");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "5");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Table);

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "colgroup");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "22pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Fragment Specimen Collection Form <br/> for&nbsp;" + AntiXssEncoder.HtmlEncode(p.LAST_NAME, false) + ",&nbsp;" + AntiXssEncoder.HtmlEncode(p.FIRST_NAME, false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(p.MIDDLE_NAME, false));
                htmlWriter.WriteBreak();

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "colgroup");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Entered/Updated by&nbsp;" + fragKit.UPDATEDBY + "&nbsp;on&nbsp;" + fragKit.UPDATED.ToShortDateString());

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "col");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Question");
                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "col");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.FontSize, "12pt");
                htmlWriter.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "#F7F6F3");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Th);

                htmlWriter.Write("Answer");
                htmlWriter.RenderEndTag();

                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Description of Fragment 1 Location in Body:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Fragment_1_Location);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Description of Fragment 2 Location in Body:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Fragment_2_Location);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Description of Fragment 3 Location in Body:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Fragment_3_Location);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Fragment Removal Date:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                if (fragKit.Date_Fragment_Removal.HasValue)
                    htmlWriter.Write(fragKit.Date_Fragment_Removal.Value.ToShortDateString());
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Duty/Location Where Fragment(s) Injury Occurred:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Duty_Location_Injury_Occurred);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                if (!String.IsNullOrEmpty(fragKit.Duty_Location_Injury_Occurred))
                {
                    if (fragKit.Duty_Location_Injury_Occurred.Equals("Other"))
                    {
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                        htmlWriter.Write("Other Location Where Fragment Injury Occurred:");

                        htmlWriter.RenderEndTag();
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                        htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                        htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                        htmlWriter.Write(fragKit.Other_Location_Injury_Occurred);
                        htmlWriter.Write("&nbsp;");
                        htmlWriter.RenderEndTag();
                        htmlWriter.RenderEndTag();
                    }
                }

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Name of Referring VAMC:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Name_Referring_VAMC);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Referring VAMC Address:");

                htmlWriter.RenderEndTag();

                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write(fragKit.Referring_VAMC_Street_Address1);
                htmlWriter.WriteBreak();
                htmlWriter.Write(fragKit.Referring_VAMC_Street_Address2);
                htmlWriter.WriteBreak();
                htmlWriter.Write(fragKit.Referring_VAMC_Street_Address3);
                htmlWriter.WriteBreak();
                htmlWriter.Write(fragKit.Referring_VAMC_MailCode);
                htmlWriter.WriteBreak();
                htmlWriter.Write(fragKit.Referring_VAMC_City);
                htmlWriter.Write("&nbsp;");
                htmlWriter.Write(fragKit.Referring_VAMC_State);
                htmlWriter.Write("&nbsp;");
                htmlWriter.Write(fragKit.Referring_VAMC_PostalCode);
                if (fragKit.Referring_VAMC_ZipPlus4 != null && fragKit.Referring_VAMC_ZipPlus4.Length > 0)
                {
                    htmlWriter.Write("-");
                    htmlWriter.Write(fragKit.Referring_VAMC_ZipPlus4);
                }
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Referring Surgeon/Care Provider Name:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Referring_Provider_Name);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Pager Number (of referring surgeon/care provider):");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Provider_Pager_Number);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Telephone Number (of referring surgeon/care provider):");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Provider_Telephone_Number);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Fax Number (of referring surgeon/care provider):");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Provider_Fax_Number);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Referring Facility Contact Name:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Referring_Facility_Contact_Name);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);

                htmlWriter.Write("Referring Facility Contact Phone:");

                htmlWriter.RenderEndTag();
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Scope, "row");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "Left");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.Write(fragKit.Referring_Facility_Contact_Phone);
                htmlWriter.Write("&nbsp;");
                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "3");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "center");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.WriteBreak();

                htmlWriter.Write("<b>VA Sensitive</b>");

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Tr);
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Colspan, "2");
                htmlWriter.AddAttribute(HtmlTextWriterAttribute.Align, "center");
                htmlWriter.RenderBeginTag(HtmlTextWriterTag.Td);
                htmlWriter.WriteBreak();

                htmlWriter.RenderEndTag();
                htmlWriter.RenderEndTag();

                //table
                htmlWriter.RenderEndTag();
                //center
                htmlWriter.RenderEndTag();
                //body
                htmlWriter.RenderEndTag();
                //html
                htmlWriter.RenderEndTag();

                ReportHTML.Text = writer.ToString();
            }
            else
            {
                ReportHTML.Text = "There was an error retrieving this Questionnaire";
            }
        }

        protected void SetStdWkfCaseTypeIds()
        {
            List<VIRP.CRS.BO.STD_WKFCASETYPE> lCaseType = STD_WKFCASETYPEManager.GetItems(userId, registryId);

            foreach (VIRP.CRS.BO.STD_WKFCASETYPE ct in lCaseType)
            {
                if (ct.CODE == "BIOLOGICAL MONITORING")
                {
                    bioWkfCaseTypeId = ct.ID;
                }
                else if (ct.CODE == "FRAGMENT ANALYSIS")
                {
                    fragWkfCaseTypeId = ct.ID;
                }
            }
        }

        protected void Close_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }
    }
}
